require( "scripts/style.lua" );
require( "locations/defines.lua" );
------------------------------------- Copyright Font
App_CopyrightFont = {
	edwardian_medium,
	17,
	WhiteColor
};

------------------------------------- Oval buttons used on options and prelevel screens
CSOvalFont = {edwardian_medium, 20, WhiteColor};

CSOvalAmberButtonStyle = {
    sound = "audio/sfx/buttonclick.ogg",
    font = CSOvalFont,
    flags = kHAlignCenter + kVAlignCenter,
    graphics = {"ui/buttons/oval_amber_up", "ui/buttons/oval_amber_down", "ui/buttons/oval_amber_down"},
    w = 113, h = 74,
};

CSOvalGreenButtonStyle = {
    sound = "audio/sfx/buttonclick.ogg",
    font = CSOvalFont,
    flags = kHAlignCenter + kVAlignCenter,
    graphics = {"ui/buttons/oval_green_up", "ui/buttons/oval_green_down", "ui/buttons/oval_green_down"},
    w = 113, h = 74,
};

CSOvalPurpleButtonStyle = {
    sound = "audio/sfx/buttonclick.ogg",
    font = CSOvalFont,
    flags = kHAlignCenter + kVAlignCenter,
    graphics = {"ui/buttons/oval_purple_up", "ui/buttons/oval_purple_down", "ui/buttons/oval_purple_down"},
    w = 113, h = 74,
};

CSOvalDarkBlueButtonStyle = {
    sound = "audio/sfx/buttonclick.ogg",
    font = CSOvalFont,
    flags = kHAlignCenter + kVAlignCenter,
    graphics = {"ui/buttons/oval_dk_blue_up", "ui/buttons/oval_dk_blue_down", "ui/buttons/oval_dk_blue_down"},
    w = 113, h = 74,
};

CSOvalLightBlueButtonStyle = {
    sound = "audio/sfx/buttonclick.ogg",
    font = CSOvalFont,
    flags = kHAlignCenter + kVAlignCenter,
    graphics = {"ui/buttons/oval_lt_blue_up", "ui/buttons/oval_lt_blue_down", "ui/buttons/oval_lt_blue_down"},
    w = 113, h = 74,
};

CSOvalMagentaButtonStyle = {
    sound = "audio/sfx/buttonclick.ogg",
    font = CSOvalFont,
    flags = kHAlignCenter + kVAlignCenter,
    graphics = {"ui/buttons/oval_magenta_up", "ui/buttons/oval_magenta_down", "ui/buttons/oval_magenta_down"},
    w = 113, h = 74,
};

CSOvalRedButtonStyle = {
    sound = "audio/sfx/buttonclick.ogg",
    font = CSOvalFont,
    flags = kHAlignCenter + kVAlignCenter,
    graphics = {"ui/buttons/oval_red_up", "ui/buttons/oval_red_down", "ui/buttons/oval_red_down"},
    w = 113, h = 74,
};
----------------------------------------------------------------------------------------------------------
CSMMCenterButtonStyle = {
    sound = "audio/sfx/buttonclick.ogg",
    graphics = {"ui/buttons/mm_center_up", "ui/buttons/mm_center_down", "ui/buttons/mm_center_over"},
    w = 128, h = 98,
};
CSMMRight1ButtonStyle = {
    sound = "audio/sfx/buttonclick.ogg",
    graphics = {"ui/buttons/mm_right_1_up","ui/buttons/mm_right_1_down","ui/buttons/mm_right_1_over"},
    w = 132, h = 118,
};
CSMMRight2ButtonStyle = {
    sound = "audio/sfx/buttonclick.ogg",
    graphics = { "ui/buttons/mm_right_2_up","ui/buttons/mm_right_2_down","ui/buttons/mm_right_2_over" },
    w = 132, h = 124,
};
CSMMLargeButtonStyle = {
    sound = "audio/sfx/buttonclick.ogg",
    graphics = {"ui/buttons/mm_large_up", "ui/buttons/mm_large_down", "ui/buttons/mm_large_over"},
    w = 146, h = 129,
};
CSMMLongButtonStyle = {
    sound = "audio/sfx/buttonclick.ogg",
    graphics = {"ui/buttons/mm_long_up", "ui/buttons/mm_long_down", "ui/buttons/mm_long_up"},
    w = 214,h = 42,
};
CSMMOvalButtonStyle = {
    sound = "audio/sfx/buttonclick.ogg",
    graphics = {"ui/buttons/mm_oval_up", "ui/buttons/mm_oval_down", "ui/buttons/mm_oval_over"},
    w = 118,h = 82,
};
CSMMLargeOvalButtonStyle = {
    sound = "audio/sfx/buttonclick.ogg",
    graphics = {"ui/buttons/mm_oval_large_up", "ui/buttons/mm_oval_large_down", "ui/buttons/mm_oval_large_over"},
    w = 146,h = 79,
};
----------------------------------------------------------------------------------------------------------
CSCheckBoxStyle = {
    type        = kToggle,
    w           = 76,
    h           = 30,
    graphics = {"ui/buttons/cs_check_off", "ui/buttons/cs_check_on", "ui/buttons/cs_check_off", "ui/buttons/cs_check_on"},
};
CSCheckBoxCircleStyle = {
    type        = kToggle,
    w           = 32,
    h           = 31,
    graphics = {"ui/buttons/cs_check2_off", "ui/buttons/cs_check2_on", "ui/buttons/cs_check2_off", "ui/buttons/cs_check2_on"},
};

CSOptionsSliderStyle = {
	railtop			= "ui/slider/transparent",
	railmid			= "ui/slider/transparent",
	railbot			= "ui/slider/transparent",
	sliderimage		= "ui/slider/sliderknob_blimp",
	sliderrollimage = "ui/slider/sliderknob_blimp_over",
};

CSMainMenuTitle = {
	font = {edwardian_medium, 60, BlackColor},
	flags = kHAlignCenter + kVAlignCenter,
};

CSMainMenuButton = {
	graphics = App_StandardButtonGraphics,
	font = {edwardian_medium, 18, BlackColor},
	flags = kHAlignCenter + kVAlignCenter,
};

CSTutorialTextFont = {
	edwardian_medium,
	15,
	BlackColor
};

CSUpgradePriceButton_Graphics = {
	"btn_upgrade_price_up","btn_upgrade_price_up","btn_upgrade_price_up"
};

CSUpgrade_SliderStyle = {
	parent			= App_DefaultStyle,
	railtop			= "ui/slider/prelevel_top",
	railmid			= "ui/slider/prelevel_mid",
	railbot			= "ui/slider/prelevel_bot",
	sliderimage		= "ui/slider/prelevel_knob",
	sliderrollimage = "ui/slider/prelevel_knobover",
	yoffset			= -1,
};

CSUpgradeTab_HeaderStyle = {
	font = {edwardian_medium, 14, BlackColor},
	flags = kHAlignLeft + kVAlignTop
};

CSUpgradeTab_ContentStyle = {
	font = {edwardian_medium, 12, BlackColor},
	flags = kHAlignLeft + kVAlignTop
};

CSUpgradeToggle_TextStyle = {
	font = {edwardian_medium, 18, BlackColor},
	flags = kHAlignCenter + kVAlignCenter
};


---------------------STORY OBJECTS
CSStoryYesAssets = {
    baseDir = "ui/buttons/",
	default = {
		{state = "default", file="oval_green_up", anim=false},
		{state = "over", file="oval_green_down", anim=false},
		{state = "down", file="oval_green_down", anim=false},
	},
}
CSStoryNoAssets = {
    baseDir = "ui/buttons/",
	default = {
		{state = "default", file="oval_red_up", anim=false},
		{state = "over", file="oval_red_down", anim=false},
		{state = "down", file="oval_red_down", anim=false},
	},
}
CSStoryButtonLeft = {
	baseDir = "ui/story/",
    sound = "audio/sfx/buttonclick.ogg",
	x = 485,
	y = 500,
	font = {edwardian_medium, 22, WhiteColor},
	assets = CSStoryYesAssets,
	children = {
		fluff = {
		    x = 60, y = 0,
			layer = -1,
			mouse = false,
			leaf = false,
			hflip = true,
			baseDir = "ui/buttons/",
			assets = {
				base = {
					{state="default", file="button_trim", anim=false, mask="button_trim.mask"}
				}
			}
		}
	}
}
CSStoryButtonRight = {
	baseDir = "ui/story/",
    sound = "audio/sfx/buttonclick.ogg",
	x = 683,
	y = 500,
	font = {edwardian_medium, 22, WhiteColor},
	assets = CSStoryNoAssets,
	children = {
		fluff = {
		    x = -60, y = 0,			
			layer = -1,
			mouse = false,
			leaf = false,
			baseDir = "ui/buttons/",
			assets = {
				base = {
					{state="default", file="button_trim", anim=false, mask="button_trim.mask"}
				}
			}
		}
	}
}
CSStoryButtonCorner = {
	baseDir = "ui/story/",
    sound = "audio/sfx/buttonclick.ogg",
	x = 585,
	y = 500,
	font = {edwardian_medium, 22, WhiteColor},
	assets = CSStoryYesAssets,
	children = {
	    layer = -1,
		mouse = false,
		leaf = false,
		fluff1 = {
		    x = -60, y = 0,
			baseDir = "ui/buttons/",
			assets = {
				base = {
					{state="default", file="button_trim", anim=false, mask="button_trim.mask"}
				}
			},
		},
		fluff2 = {
		    x = 60, y = 0,
			hflip = true,
			baseDir = "ui/buttons/",
			assets = {
				base = {
					{state="default", file="button_trim", anim=false, mask="button_trim.mask"}
				}
			},
		},
	}
}
CSStoryLeftTextStyle = {
	layer = 2,
	font = { caflisch_regular, 22, BlackColor },
	x = 70, y = 285,
	w = 300, h = 605,
	italic = true,
	flags = kHAlignLeft + kVAlignTop,
};
CSStoryRightTextStyle = {
	layer = 2,
	font = { caflisch_regular, 22, BlackColor },
	x = 425, y = 285,
	w = 300, h = 605,
	italic = true,
	flags = kHAlignLeft + kVAlignTop,
};
CSStoryRightTextNoPhotoStyle = {
	layer = 2,
	font = { caflisch_regular, 22, BlackColor },
	x = 425, y = 102,
	w = 300, h = 615,
	italic = true,
	flags = kHAlignLeft + kVAlignTop,
};
CSStoryTelegramTextStyle = {
    layer = 2,
    font = { edwardian_medium, 14, Color(59, 30, 44) },
    x = 495, y = 207,
    w = 220, h = 165,
    rotation = { 220, 165, 5 },
    flags = kVAlignTop + kHAlignRight,
};

CSStoryPhotoAssets = {
    default = {
		{state = "default", file="photo_evangeline" },
		{state = "krump", file="photo_krump" },
		{state = "evangeline", file="photo_evangeline" },
		{state = "agnes", file="photo_agnes" },
		{state = "chak", file="photo_chak" },
		{state = "klaus", file="photo_klaus" },
		{state = "klara", file="photo_klara" },
		{state = "abdullah", file="photo_abdullah" },
		{state = "tin", file="photo_tin" },
		{state = "pemba", file="photo_pemba" },
		{state = "bymakhra", file="photo_bymakhra" },
		{state = "ernst", file="photo_ernst" },
		{state = "nadia", file="photo_nadia" },
		{state = "jakob", file="photo_jakob" },
		{state = "ayu", file="photo_ayu" },
		{state = "jarrah", file="photo_jarrah" },
		{state = "level01", file="photo_level01" },
		{state = "level02", file="photo_level02" },
		{state = "level03", file="photo_level03" },
		{state = "level04", file="photo_level04" },
		{state = "level06", file="photo_level06" },
		{state = "level07", file="photo_level07" },
		{state = "level11", file="photo_level11" },
		{state = "level13", file="photo_level13" },
		{state = "level24", file="photo_level24" },
		{state = "level33", file="photo_level33" },
		{state = "level43", file="photo_level43" },
		{state = "level53", file="photo_level53" },
	},
};
CSStoryPhotographLeft = {
	baseDir = "ui/story/",
	x = 205, y = 150,
	rotation = {0, 0, -0.1},
	assets = CSStoryPhotoAssets,
	--[[children = {
	    wax_seal = {
	        layer = 1,
	        assets = {
	            default = {
	                { state="default", file="wax_seal" },
	            },
	        },
	    },
	},]]
};
CSStoryPhotographRight = {
    baseDir = "ui/story/",
	x = 570, y = 150,
	rotation = {0, 0, 0.2},
	assets = CSStoryPhotoAssets,
};

CSStoryTelegramLarge = {
    baseDir = "ui/story/",
    layer = 1,
    assets = {
        default = {
	        {state="default", file="telegram_large" },
	    },
    },
    text = {
        header = {
            x = 515, y = 170, w = 200, h = 25,
            font = { edwardian_medium, 18, Color(98, 56, 81) },
            rotation = {155, 25, 5},
            flags = kVAlignTop + kHAlignLeft,
            label = "story_telegram_title",
        }
    },
};

CSStoryBackgroundAssets = {
    baseDir = "ui/story/",
	diary = {
		{state="default", file="diary_open"},
	},
};

